IF EXISTS( SELECT 1 FROM sys.views
				WHERE  name = 'V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM')
	BEGIN
		DROP VIEW V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM;
	END;
GO

CREATE VIEW V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM
AS
	 WITH BASE
		  AS ( SELECT DISTINCT
					g.CD_EMP
					, f.CD_FILIAL 
					, l.CD_GRP_PRT
					, v.CD_CTR_DEPO
				FROM
					EST_PROD_PRT_GRP_RESSUPRIMENTO V
					INNER JOIN EST_PROD_PRT_GRP_RESSUPRIMENTO_EST_ARV_MERC_LINHA l ON l.CD_GRP_PRT = V.CD_GRP_PRT					
					INNER JOIN EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL r ON l.CD_GRP_PRT = r.CD_GRP_PRT
					INNER JOIN EST_ARV_GRP_RESSUPRIMENTO_EST_ARV_MERC_LINHA g ON l.CD_EMP = g.CD_EMP
					AND l.CD_ARV_MERC_LINHA = g.CD_ARV_MERC_LINHA
					INNER JOIN EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL f ON 
						f.CD_EMP	 = g.CD_EMP
					AND f.CD_GRP_RES = g.CD_GRP_RES)
		  SELECT
				 b.CD_EMP
			   , b.CD_FILIAL 
			   , b.CD_GRP_PRT
			   , COUNT(*) ORDEM
			   , b.CD_CTR_DEPO
		  FROM
			  BASE a
			  JOIN BASE b ON a.CD_EMP = b.CD_EMP
							 AND a.CD_FILIAL <= b.CD_FILIAL 
							 AND (a.CD_FILIAL < b.CD_FILIAL 
								  OR a.CD_GRP_PRT <= b.CD_GRP_PRT
								  )
		  GROUP BY
				   b.CD_EMP
				 , b.CD_FILIAL 
				 , b.CD_GRP_PRT
				 , b.CD_CTR_DEPO;
GO
 